/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class GlobalPos {
    private final BlockPos pos;
    private final int dimension;

    private GlobalPos(BlockPos pos, int dim) {
        this.pos = pos;
        this.dimension = dim;
    }

    public static GlobalPos of(int x, int y, int z, int dim) {
        return new GlobalPos(new BlockPos(x, y, z), dim);
    }

    public static GlobalPos of(int dim, BlockPos pos) {
        return new GlobalPos(pos, dim);
    }

    public boolean checkCoordinates(String[] coordinates) {
        int xPos = Integer.parseInt(coordinates[0]);
        int yPos = Integer.parseInt(coordinates[1]);
        int zPos = Integer.parseInt(coordinates[2]);
        int dim = coordinates.length == 4 ? Integer.parseInt(coordinates[3]) : 0;
        return this.pos.func_177958_n() == xPos && this.pos.func_177956_o() == yPos && this.pos.func_177952_p() == zPos && this.dimension() == dim;
    }

    public String toNBTString() {
        return this.pos.func_177958_n() + " " + this.pos.func_177956_o() + " " + this.pos.func_177952_p() + " " + this.dimension();
    }

    public BlockPos pos() {
        return this.pos;
    }

    public int dimension() {
        return this.dimension;
    }

    public NBTTagCompound save() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", this.pos.func_177986_g());
        tag.func_74768_a("dimension", this.dimension);
        return tag;
    }

    public static GlobalPos load(NBTTagCompound tag) {
        return new GlobalPos(BlockPos.func_177969_a((long)tag.func_74763_f("pos")), tag.func_74762_e("dimension"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GlobalPos) {
            GlobalPos otherPos = (GlobalPos)object;
            return this.dimension == otherPos.dimension && this.pos.equals((Object)otherPos.pos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pos);
    }

    public String toString() {
        return "Dimension id " + this.dimension + " " + this.pos;
    }
}

